document.addEventListener("DOMContentLoaded", () => {
    const pathLine = document.getElementById('data-line');
    const particlesGroup = document.getElementById('particles-group');
    const bgStarsGroup = document.getElementById('background-stars');
    const tooltip = document.getElementById('tooltip');
    const interactivePoints = document.querySelectorAll('.interactive-point');
    const totalLength = pathLine.getTotalLength();
    
    pathLine.style.strokeDasharray = totalLength;
    pathLine.style.strokeDashoffset = totalLength;
    
    pathLine.getBoundingClientRect();
    
    pathLine.style.transition = "stroke-dashoffset 2.5s ease-out";
    pathLine.style.strokeDashoffset = "0";
    const particleCount = 15; 
    const particles = [];

    for(let i=0; i<particleCount; i++) {
        const p = document.createElementNS("http://www.w3.org/2000/svg", "circle");
        p.setAttribute("r", 0); 
        p.setAttribute("fill", "#fff");
        particlesGroup.appendChild(p);
        
        particles.push({
            el: p,
            progress: Math.random(), 
            speed: 0.002 + Math.random() * 0.004,
            sizeBase: 3 + Math.random() * 3 
        });
    }

    function animateParticles() {
        particles.forEach(p => {
            p.progress += p.speed;
            if (p.progress >= 1) p.progress = 0;

            const point = pathLine.getPointAtLength(p.progress * totalLength);
            
            p.el.setAttribute("cx", point.x);
            p.el.setAttribute("cy", point.y);

            const currentSize = p.sizeBase * (0.8 + p.progress); 
            let opacity = 1;
            if(p.progress < 0.1) opacity = p.progress * 10;
            if(p.progress > 0.9) opacity = (1 - p.progress) * 10;
            
            p.el.setAttribute("r", currentSize);
            p.el.setAttribute("fill-opacity", opacity);
        });
        requestAnimationFrame(animateParticles);
    }
    setTimeout(animateParticles, 1000);

    interactivePoints.forEach(group => {
        const year = group.getAttribute('data-year');
        const val = group.getAttribute('data-val');
        const visibleCircle = group.querySelector('.pulsing-node');

        group.addEventListener("mouseenter", (e) => {
            visibleCircle.style.animation = "none";
            visibleCircle.setAttribute("r", 10);
            visibleCircle.setAttribute("fill", "#ff0055");
            
            tooltip.innerHTML = `<strong>${year}</strong><br>${val} TWh`;
            tooltip.style.left = (e.pageX + 15) + "px";
            tooltip.style.top = (e.pageY - 50) + "px";
            tooltip.style.opacity = 1;
        });

        group.addEventListener("mouseleave", () => {
            visibleCircle.style.animation = "pulse 2s infinite ease-in-out";
            visibleCircle.setAttribute("r", 6);
            visibleCircle.setAttribute("fill", "#1a1a2e");
            tooltip.style.opacity = 0;
        });
    });

    function createBackgroundEffect() {
        const svgBox = document.getElementById('creative-chart').viewBox.baseVal;
        
        for (let i = 0; i < 50; i++) {
            const circle = document.createElementNS("http://www.w3.org/2000/svg", "circle");
            const x = Math.random() * svgBox.width;
            const y = Math.random() * svgBox.height;
            const r = Math.random() * 1.5 + 0.5;

            circle.setAttribute("cx", x);
            circle.setAttribute("cy", y);
            circle.setAttribute("r", r);
            circle.setAttribute("class", "bg-star");
            
            const duration = (Math.random() * 4 + 2) + "s";
            circle.style.setProperty("--duration", duration);
            circle.style.animationDelay = "-" + (Math.random() * 5) + "s";
            circle.setAttribute("fill-opacity", Math.random() * 0.3 + 0.1);
            
            bgStarsGroup.appendChild(circle);
        }
    }
    createBackgroundEffect();
});